/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: DrvAsimXcConfig.h$
   Last Modification:
    $Id: DrvAsimXcConfig.h 1 2011-09-27 16:14:21Z Eric $

    $Author: Eric $
    $Modtime: 23.01.08 10:16 $
    $Revision: 1 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    AS-Interface Master Driver
    AS-Interface Master driver xC configuration

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
     1          31.10.07    ES
        Created

**************************************************************************************/
#ifndef __DRV_ASIM_XC_CONFIG_H
#define __DRV_ASIM_XC_CONFIG_H

/* External references to the XC codings */
extern TLR_UINT32 XcCode_xpec_asim0;
extern TLR_UINT32 XcCode_xpec_asim1;
extern TLR_UINT32 XcCode_xpec_asim2;
extern TLR_UINT32 XcCode_xpec_asim3;

extern TLR_UINT32 XcCode_rpu_asim0;
extern TLR_UINT32 XcCode_rpu_asim1;
extern TLR_UINT32 XcCode_rpu_asim2;
extern TLR_UINT32 XcCode_rpu_asim3;

extern TLR_UINT32 XcCode_tpu_asim0;
extern TLR_UINT32 XcCode_tpu_asim1;
extern TLR_UINT32 XcCode_tpu_asim2;
extern TLR_UINT32 XcCode_tpu_asim3;

#define XC_CODE_ASIM_XPEC0 ((TLR_UINT32 FAR*)&XcCode_xpec_asim0)
#define XC_CODE_ASIM_XPEC1 ((TLR_UINT32 FAR*)&XcCode_xpec_asim1)
#define XC_CODE_ASIM_XPEC2 ((TLR_UINT32 FAR*)&XcCode_xpec_asim2)
#define XC_CODE_ASIM_XPEC3 ((TLR_UINT32 FAR*)&XcCode_xpec_asim3)

#define XC_CODE_ASIM_RPU0 ((TLR_UINT32 FAR*)&XcCode_rpu_asim0)
#define XC_CODE_ASIM_RPU1 ((TLR_UINT32 FAR*)&XcCode_rpu_asim1)
#define XC_CODE_ASIM_RPU2 ((TLR_UINT32 FAR*)&XcCode_rpu_asim2)
#define XC_CODE_ASIM_RPU3 ((TLR_UINT32 FAR*)&XcCode_rpu_asim3)

#define XC_CODE_ASIM_TPU0 ((TLR_UINT32 FAR*)&XcCode_tpu_asim0)
#define XC_CODE_ASIM_TPU1 ((TLR_UINT32 FAR*)&XcCode_tpu_asim1)
#define XC_CODE_ASIM_TPU2 ((TLR_UINT32 FAR*)&XcCode_tpu_asim2)
#define XC_CODE_ASIM_TPU3 ((TLR_UINT32 FAR*)&XcCode_tpu_asim3)

#endif /* #ifndef __DRV_ASIM_XC_CONFIG_H */

/**************************************************************************************/
/*------------------------------------------------------------------------------------*/
/*-----------------------------EOF----------------------------------------------------*/
/*------------------------------------------------------------------------------------*/
/**************************************************************************************/

